<?php

namespace FCAPoland\FinancialAPI;

use Exception;
use FCAPoland\FinancialAPI\Model\CalculateResponseData;
use FCAPoland\FinancialAPI\Model\DetectResponseData;
use FCAPoland\FinancialAPI\Model\RequestData;
use GuzzleHttp\Exception\GuzzleException;
use Psr\Log\LoggerAwareTrait;

class FinancialAPI
{
    use LoggerAwareTrait;

    /**
     * @var RequestClient
     */
    private $requestClient;

    private $webSocketClient;

    public function __construct(Config $config = null)
    {
        if (is_null($config)) {
            $config = new Config();
        }

        $this->requestClient = new RequestClient\HTTP($config, $this->logger);
        $this->webSocketClient = new RequestClient\WebSocket($config, $this->logger);
    }

    /**
     * @param RequestData $requestData
     * @return DetectResponseData
     * @throws GuzzleException
     * @throws Exception
     */
    public function detectCalculators(RequestData $requestData): DetectResponseData
    {
        if ($this->webSocketClient->isEnabled()) {
            try {
                return $this->webSocketClient->detectCalculators($requestData);
            } catch (Exception $exception) {
                return $this->requestClient->detectCalculators($requestData);
            }
        } else {
            return $this->requestClient->detectCalculators($requestData);
        }
    }

    /**
     * @param RequestData $requestData
     * @return CalculateResponseData
     * @throws GuzzleException
     */
    public function calculate(RequestData $requestData): CalculateResponseData
    {
        if ($this->webSocketClient->isEnabled()) {
            try {
                return $this->webSocketClient->calculate($requestData);
            } catch (Exception $exception) {
                return $this->requestClient->calculate($requestData);
            }
        } else {
            return $this->requestClient->calculate($requestData);
        }
    }
}
