<?php

declare(strict_types=1);

use Rector\Config\RectorConfig;
use Rector\Set\ValueObject\LevelSetList;

return RectorConfig::configure()
    ->withSets([LevelSetList::UP_TO_PHP_82])
    ->withPaths([
        __DIR__ . '/src',
    ])
    ->withSkip([
        \Rector\CodeQuality\Rector\LogicalAnd\LogicalToBooleanRector::class,
        \Rector\DeadCode\Rector\PropertyProperty\RemoveNullPropertyInitializationRector::class,
        \Rector\CodingStyle\Rector\Stmt\NewlineAfterStatementRector::class
    ])
    // here we can define, what prepared sets of rules will be applied
    ->withPreparedSets(
        true,
        true,
        true
    );
