<?php

namespace FCAPoland\FinancialAPI\Model;

use FCAPoland\FinancialAPI\Model\Response\Calculation;
use InvalidArgumentException;

class CalculateResponseData
{
    /**
     * @var array
     */
    private $vehicleCalculations = [];

    public function __construct(array $data)
    {
        foreach ($data as $vehicleId => $calculationData) {
            $calculation = new Calculation($calculationData);
            $this->vehicleCalculations[$vehicleId] = $calculation;
        }
    }

    public function getCalculationByVehicleId(string $vehicleId): Calculation
    {
        if (isset($this->vehicleCalculations[$vehicleId])) {
            return $this->vehicleCalculations[$vehicleId];
        }
        throw new InvalidArgumentException('Vehicle with id [' . $vehicleId . '] was not send to calculation');
    }

    public function getAllCalculations(bool $asArray = false): array
    {
        if ($asArray) {
            $array = [];

            foreach ($this->vehicleCalculations as $vehicleId => $calculation) {
                $array[$vehicleId] = $calculation->toArray();
            }

            return $array;
        }

        return $this->vehicleCalculations;
    }
}
