<?php

namespace FCAPoland\FinancialAPI\Model;

use FCAPoland\FinancialAPI\Model\Response\Detection;
use InvalidArgumentException;

class DetectResponseData
{
    /**
     * @var array
     */
    private $vehicleDetections = [];

    public function __construct(array $data)
    {
        foreach ($data as $vehicleId => $detectionData) {
            $this->vehicleDetections[$vehicleId] = new Detection($vehicleId, $detectionData);
        }
    }

    public function getDetectionByVehicleId(string $vehicleId): Detection
    {
        if (isset($this->vehicleDetections[$vehicleId])) {
            return $this->vehicleDetections[$vehicleId];
        }
        throw new InvalidArgumentException('Vehicle with id [' . $vehicleId . '] was not send to calculation');
    }

    public function getAllDetections(bool $asArray = false): array
    {
        if ($asArray) {
            $array = [];

            foreach ($this->vehicleDetections as $vehicleId => $calculation) {
                $array[$vehicleId] = $calculation->toArray();
            }

            return $array;
        }

        return $this->vehicleDetections;
    }
}
