<?php

namespace FCAPoland\FinancialAPI\Model\Request;

use InvalidArgumentException;

class Vehicle
{
    public $fuelType;
    /**
     * @var string
     */
    protected $brand;

    /**
     * @var string
     */
    protected $modelCode;

    /**
     * @var string
     */
    protected $modelName;

    /**
     * @var float
     */
    protected $netPrice;

    /**
     * @var float
     */
    protected $grossPrice;

    /**
     * @var float
     */
    protected $baseNetPrice;

    /**
     * @var float
     */
    protected $baseGrossPrice;

    /**
     * @var string
     */
    protected $status;

    /**
     * @var string
     */
    protected $versionId;

    /**
     * @var string
     */
    protected $versionName;

    /**
     * @var string
     */
    protected $lcdv;

    protected $fieldsList = [
        'brand',
        'modelCode',
        'modelName',
        'netPrice',
        'grossPrice',
        'baseNetPrice',
        'baseGrossPrice',
        'status',
        'versionId',
        'versionName',
        'fuelType',
        'lcdv',
    ];

    public function __construct(array $dataArray = [])
    {
        foreach ($dataArray as $key => $value) {
            if (in_array($key, $this->fieldsList)) {
                $this->$key = $value;
            } else {
                throw new InvalidArgumentException("Key [" . $key . "] is not acceptable for " . self::class);
            }
        }
    }

    public function toArray(): array
    {
        $array = [];

        foreach ($this->fieldsList as $field) {
            if (isset($this->$field)) {
                $array[$field] = $this->$field;
            }
        }

        return $array;
    }

    public function getBrand(): string
    {
        return $this->brand;
    }

    public function setBrand(string $brand): self
    {
        $this->brand = $brand;
        return $this;
    }

    public function getModelCode(): string
    {
        return $this->modelCode;
    }

    public function setModelCode(string $modelCode): self
    {
        $this->modelCode = $modelCode;
        return $this;
    }

    public function getModelName(): string
    {
        return $this->modelName;
    }

    public function setModelName(string $modelName): self
    {
        $this->modelName = $modelName;
        return $this;
    }

    public function getNetPrice(): float
    {
        return $this->netPrice;
    }

    public function setNetPrice(float $netPrice): self
    {
        $this->netPrice = $netPrice;
        return $this;
    }

    public function getGrossPrice(): float
    {
        return $this->grossPrice;
    }

    public function setGrossPrice(float $grossPrice): self
    {
        $this->grossPrice = $grossPrice;
        return $this;
    }

    public function getBaseNetPrice(): float
    {
        return $this->baseNetPrice;
    }

    public function setBaseNetPrice(float $baseNetPrice): self
    {
        $this->baseNetPrice = $baseNetPrice;
        return $this;
    }

    public function getBaseGrossPrice(): float
    {
        return $this->baseGrossPrice;
    }

    public function setBaseGrossPrice(float $baseGrossPrice): self
    {
        $this->baseGrossPrice = $baseGrossPrice;
        return $this;
    }

    public function getStatus(): string
    {
        return $this->status;
    }

    public function setStatus(string $status): self
    {
        $this->status = $status;
        return $this;
    }

    public function getVersionId(): string
    {
        return $this->versionId;
    }

    public function setVersionId(string $versionId): self
    {
        $this->versionId = $versionId;
        return $this;
    }

    public function getVersionName(): string
    {
        return $this->versionName;
    }

    public function setVersionName(string $versionName): self
    {
        $this->versionName = $versionName;
        return $this;
    }

    public function getFuelType(): string
    {
        return $this->fuelType;
    }

    public function setFuelType(string $fuelType): self
    {
        $this->fuelType = $fuelType;
        return $this;
    }

    public function getLCDV(): string
    {
        return $this->lcdv;
    }

    public function setLCDV(string $lcdv): self
    {
        $this->lcdv = $lcdv;
        return $this;
    }
}
