<?php

namespace FCAPoland\FinancialAPI\Model\Response\Calculation\CurrentField;

use InvalidArgumentException;

class CurrentField
{
    /**
     * @var float
     */
    protected $value;

    /**
     * @var string
     */
    protected $label;

    /**
     * @var string
     */
    protected $description;

    protected $fieldsList = [
        'value',
        'label',
        'description'
    ];

    public function __construct(array $dataArray)
    {
        foreach ($dataArray as $key => $value) {
            if (in_array($key, $this->fieldsList)) {
                $this->$key = $value;
            } else {
                throw new InvalidArgumentException("Key [" . $key . "] is not acceptable for " . self::class);
            }
        }
    }

    public function toArray(): array
    {
        $array = [];

        foreach ($this->fieldsList as $field) {
            if (isset($this->$field)) {
                $array[$field] = $this->$field;
            }
        }

        return $array;
    }

    public function getValue(): float
    {
        return $this->value;
    }

    public function getLabel(): string
    {
        return $this->label;
    }

    public function getDescription(): string
    {
        return $this->description;
    }
}
