<?php

namespace FCAPoland\FinancialAPI\Model\Response\Detection;

use FCAPoland\FinancialAPI\Model\Response\Calculation;

class FinancialProduct
{
    /**
     * @var int
     */
    protected $calculatorId;

    /**
     * @var Calculation
     */
    protected $calculation;

    public function __construct(int $calculatorId, array $calculation)
    {
        $this->calculatorId = $calculatorId;
        $this->calculation = new Calculation($calculation);
    }

    public function toArray(): array
    {
        return [
            'calculatorId' => $this->calculatorId,
            'calculation' => $this->calculation->toArray()
        ];
    }

    public function getCalculatorId(): int
    {
        return $this->calculatorId;
    }

    public function getCalculation(): Calculation
    {
        return $this->calculation;
    }
}
