<?php

namespace FCAPoland\FormsLib\Field;

use FCAPoland\FormsLib\Field\Rule\MaxLength;
use FCAPoland\FormsLib\Field\Rule\NotEmpty;

/**
 * Class AddressField
 * @package FCAPoland\FormsLib\Field
 */
class AddressField extends BaseField
{
    /**
     * @var string
     */
    protected $type = BaseField::TYPE_TEXT;

    /**
     * @var string
     */
    protected $name = 'address';

    /** @var bool */
    protected $required = false;

    /**
     * @var string
     */
    protected $place_holder = 'Adres';

    /**
     * FirstNameField constructor.
     */
    public function __construct()
    {
        $this->setDefaultRules();
    }

    /**
     * Set default rules for this field
     */
    protected function setDefaultRules()
    {
        if (!is_array($this->getOptionValues()) and is_string($this->getOptionValues())) {
            $this->setOptionValues([$this->getOptionValues()]);
        }

        $this->setRules(
            [
                NotEmpty::class => [],
                MaxLength::class => [200],
            ]
        );
    }
}
