<?php

namespace FCAPoland\FormsLib\Field;

use FCAPoland\FormsLib\Field\Rule\IsEmail;
use FCAPoland\FormsLib\Field\Rule\MaxLength;
use FCAPoland\FormsLib\Field\Rule\NotEmpty;

/**
 * Class EmailField
 * @package FCAPoland\FormsLib\Field
 */
class EmailField extends BaseField
{
    /**
     * @var string
     */
    protected $type = BaseField::TYPE_EMAIL;

    /**
     * @var string
     */
    protected $name = 'email';

    /**
     * @var string
     */
    protected $place_holder = 'E-mail';

    /**
     * EmailField constructor.
     */
    public function __construct()
    {
        $this->setDefaultRules();
    }

    /**
     * Set default rules for this field
     */
    protected function setDefaultRules()
    {
        if (!is_array($this->getOptionValues()) and is_string($this->getOptionValues())) {
            $this->setOptionValues([$this->getOptionValues()]);
        }

        $this->setRules(
            [
                NotEmpty::class => [],
                IsEmail::class => [],
                MaxLength::class => [100],
            ]
        );
    }
}
