<?php

namespace FCAPoland\FormsLib\Config;

/**
 * Class LibConfig
 * @package FCAPoland\FormsLib\Config
 */
class LibConfig extends BaseConfig
{
    /**
     * @return string
     */
    public function getStoragePath()
    {
        return isset($this->getConfig()['lead_api_cache']) ? $this->getConfig()['lead_api_cache'] : './cache_lead_api.cache';
    }

    /**
     * @return string|null
     */
    public function getPrivacyPolicyHash()
    {
        return isset($this->getConfig()['policy_hash']) ? $this->getConfig()['policy_hash'] : null;
    }

    /**
     * @return bool|array
     */
    public function getForms()
    {
        return isset($this->getConfig()['forms']) ? $this->getConfig()['forms'] : false;
    }
}
