<?php

namespace FCAPoland\FormsLib\Field;

use FCAPoland\FormsLib\Field\Rule\InArray;
use FCAPoland\FormsLib\Field\Rule\NotEmpty;

/**
 * Class CTAField
 * @package FCAPoland\FormsLib\Field
 */
class CTAField extends BaseField
{
    /**
     * @var string
     */
    protected $type = BaseField::TYPE_HIDDEN;

    /**
     * @var string
     */
    protected $name = 'cta';

    /**
     * @var string
     */
    protected $label = 'Wybierz typ formularza';

    /**
     * CTAField constructor.
     * @param $type
     * @param $options
     */
    public function __construct($type, $options = null)
    {
        $this->setOptionValues($options);
        $this->setDefaultRules();
        $this->setType($type);
    }

    /**
     * Set default rules for this field
     */
    protected function setDefaultRules()
    {
        if (!is_array($this->getOptionValues()) and is_string($this->getOptionValues())) {
            $this->setOptionValues([$this->getOptionValues()]);
        }

        $this->setRules(
            [
                NotEmpty::class => [],
                InArray::class => [array_keys($this->getOptionValues())]
            ]
        );
    }
}
