<?php

namespace FCAPoland\FormsLib\Field;

use FCAPoland\FormsLib\Field\Rule\NotEmpty;
use FCAPoland\FormsLib\Field\Rule\ValidDate;

/**
 * Class AppointmentDateField
 * @package FCAPoland\FormsLib\Field
 */
class AppointmentDateField extends BaseField
{
    /**
     * @var string
     */
    protected $type = BaseField::TYPE_DATE;

    /**
     * @var string
     */
    protected $name = 'appointment_date';

    /**
     * @var string
     */
    protected $place_holder = 'Data jazdy testowej';

    /**
     * EmailField constructor.
     */
    public function __construct()
    {
        $this->setDefaultRules();
    }

    /**
     * Set default rules for this field
     */
    protected function setDefaultRules()
    {
        if (!is_array($this->getOptionValues()) and is_string($this->getOptionValues())) {
            $this->setOptionValues([$this->getOptionValues()]);
        }

        $this->setRules(
            [
                NotEmpty::class => [],
                ValidDate::class => [],
            ]
        );
    }
}
