<?php

namespace FCAPoland\FormsLib\Field;

use FCAPoland\FormsLib\Field\Rule\IsEmail;
use FCAPoland\FormsLib\Field\Rule\MaxLength;
use FCAPoland\FormsLib\Field\Rule\NotEmpty;
use FCAPoland\FormsLib\Field\Rule\Same;

/**
 * Class RepeatEmailField
 * @package FCAPoland\FormsLib\Field
 */
class RepeatEmailField extends BaseField
{
    /**
     * @var string
     */
    protected $type = BaseField::TYPE_EMAIL;

    /**
     * @var string
     */
    protected $name = 'repeat_email';

    /**
     * @var string
     */
    protected $place_holder = 'Powtórz e-mail';

    /**
     * RepeatEmailField constructor.
     */
    public function __construct()
    {
        $this->setDefaultRules();
    }

    /**
     * Set default rules for this field
     */
    protected function setDefaultRules()
    {
        if (!is_array($this->getOptionValues()) and is_string($this->getOptionValues())) {
            $this->setOptionValues([$this->getOptionValues()]);
        }

        $this->setRules(
            [
                NotEmpty::class => [],
                IsEmail::class => [],
                MaxLength::class => [100],
            ]
        );
    }

    /**
     * Check if value is valid
     * @param $value
     * @param $value_for_compare
     * @return bool
     */
    public function isValidRepeatEmail($value, $value_for_compare)
    {
        if ($value != $value_for_compare) {
            $this->error_messages[] = "Adresy e-mail nie są takie same";
        }
        return $this->error_messages == null ? true : false;
    }
}
