<?php

namespace FCAPoland\FormsLib\Field\Rule;

use FCAPoland\FormsLib\Field\FieldInterface;
use ReCaptcha\ReCaptcha;

/**
 * Class CheckRecaptcha
 * @package FCAPoland\FormsLib\Field\Rule
 */
class CheckRecaptcha extends BaseRule
{
    /**
     * @var string
     */
    //protected $regex = "/^(?!\s*$).+$/";

    /**
     * @var string
     */
    private $site_key;

    /**
     * @var string
     */
    private $secret_key;

    /**
     * CheckRecaptcha constructor.
     * @param FieldInterface $field
     * @param $site_key string
     * @param $secret_key string
     */
    public function __construct(FieldInterface $field, $site_key, $secret_key)
    {
        $this->field = $field;
        $this->secret_key = $secret_key;
        $this->site_key = $site_key;
    }


    /**
     * @param $value
     * @return bool
     */
    public function isValidValue($value)
    {
        $recaptcha = new ReCaptcha($this->secret_key);

        $recaptcha_response = $recaptcha->verify($value);

        return $recaptcha_response->isSuccess();
    }
}
