<?php

namespace FCAPoland\FormsLib;

use FCAPoland\FormsLib\Field\Rule\RuleInterface;

/**
 * Class Message
 * @package FCAPoland\FormsLib
 */
class Message
{
    /**
     * @var  Message  Singleton instance container
     */
    protected static $_instance;

    /**
     * @var array
     */
    protected $messages = [
        'AddressField' =>
            [
                'NotEmpty' => 'Te pole jest obowiązkowe',
                'MaxLength'  => 'Podana wartość jest zbyt długa'
            ],
        'AppointmentDateField' =>
            [
                'NotEmpty' => 'Te pole jest obowiązkowe',
                'ValidDate' => 'Niepoprawny format danych',
            ],
        'CityField' =>
            [
                'NotEmpty' => 'To pole jest obowiązkowe',
                'MaxLength' => 'Podana wartość jest zbyt długa',
            ],
        'CompanyField' =>
            [
                'NotEmpty' => 'To pole jest obowiązkowe',
                'MaxLength' => 'Podana wartość jest zbyt długa',
            ],
        'CTAField' =>
            [
                'NotEmpty' => 'Wybierz typ formularza',
                'InArray'  => 'Wybrany formularz jest nieprawidłowy'
            ],
        'DealerSincomField' =>
            [
                'NotEmpty' => 'To pole jest obowiązkowe',
                'ValidDealerSincom' => 'Niepoprawny format danych',
            ],
        'EmailField' =>
            [
                'NotEmpty' => 'To pole jest obowiązkowe',
                'IsEmail' => 'Adres email jest nieprawidłowy',
                'MaxLength' => 'Podana wartość jest zbyt długa',
            ],
        'RepeatEmailField' =>
            [
                'NotEmpty' => 'To pole jest obowiązkowe',
                'IsEmail' => 'Adres email jest nieprawidłowy',
                'MaxLength' => 'Podana wartość jest zbyt długa',
            ],
        'FirstNameField' =>
            [
                'NotEmpty' => 'To pole jest obowiązkowe',
                'MinLength' => 'Podana wartość jest zbyt krótka',
                'MaxLength' => 'Podana wartość jest zbyt długa',
            ],
        'LastNameField' =>
            [
                'NotEmpty' => 'To pole jest obowiązkowe',
                'MinLength' => 'Podana wartość jest zbyt krótka',
                'MaxLength' => 'Podana wartość jest zbyt długa',
            ],
        'ModelIDField' =>
            [
                'NotEmpty' => 'Wybierz model',
                'InArray'  => 'Wybrany model nie istnieje'
            ],
        'BrandIDField' =>
            [
                'NotEmpty' => 'Wybierz markę',
                'InArray'  => 'Wybrana marka nie istnieje'
            ],
        'PhoneField' =>
            [
                'NotEmpty' => 'To pole jest obowiązkowe',
                'IsPhone' => 'Numer telefonu jest nieprawidłowy',
                'MinLength' => 'Podana wartość jest zbyt krótka',
                'MaxLength' => 'Podana wartość jest zbyt długa',
            ],
        'ZipCodeField' =>
            [
                'NotEmpty' => 'To pole jest obowiązkowe',
                'ValidPostCode' => 'Niepoprawny format danych',
            ],
        'RecaptchaField' =>
            [
                'NotEmpty' => 'Potwierdz że jesteś człowiekiem',
                'CheckRecaptcha' => 'Potwierdz że jesteś człowiekiem',
            ]

    ];

    /**
     * @return Message
     */
    public static function getInstance()
    {
        if (Message::$_instance === null) {
            Message::$_instance = new Message();
        }

        return Message::$_instance;
    }

    /**
     * @param array $messages
     * @return $this
     */
    public function setMessages(array $messages)
    {
        $this->messages = array_merge($this->messages, $messages);
        return $this;
    }

    /**
     * @param $rule RuleInterface
     * @return string
     */
    public function getMessageFor($rule)
    {
        return isset($this->messages[$rule->getFieldName()][$rule->getRuleName()])
            ? $this->messages[$rule->getFieldName()][$rule->getRuleName()]
            : 'Not found message for ' . $rule->getFieldName() . ' - ' . $rule->getRuleName();
    }
}
