<?php

namespace FCAPoland\FormsLib\Form;

use FCAPoland\ApiPrivacyHelper\Disclaimer;
use FCAPoland\FormsLib\ClientParam\ClientParamInterface;
use FCAPoland\FormsLib\Resource\Dealer\Collection;
use FCAPoland\LeadsAPIHelper\MasterkeyFinder;
use Psr\Log\LoggerInterface;
use Psr\SimpleCache\CacheInterface;

/**
 * Class BaseForm
 * @package FCAPoland\FormsLib
 */
class BaseForm
{
    /**
     * @var string
     */
    protected $formID;

    /** @var bool  */
    protected $enable = true;

    /** @var string */
    protected $disclaimer_id;

    /** @var Disclaimer */
    protected $disclaimer;

    /** @var string|array */
    protected $cta;

    /** @var string */
    protected $brand_id;

    /** @var int */
    protected $cid;

    /** @var int */
    protected $oid;

    /** @var static */
    protected $source;

    /** @var array */
    protected $fields;

    /** @var CacheInterface */
    protected $cache;

    /** @var LoggerInterface */
    protected $logger;

    /** @var MasterkeyFinder */
    protected $masterkey;

    /**  @var array|null */
    protected $dealers_list;

    /** @var Collection|null */
    protected $form_dealers;

    /** @var FormData|null */
    protected $form_data;

    /** @var array|null */
    protected $form_data_errors = [];

    /** @var array */
    protected $form_data_absent_fields = [];

    /** @var ClientParamInterface */
    protected $client_params;

    /**
     * @var bool
     */
    protected $with_dealers = false;

    /**
     * @var bool
     */
    protected $with_sub_dealers = true;

    /**
     * Path for backup/fallback helpers cache
     * @var string
     */
    protected $helpers_cache_path = './forms_lib';

    /**
     * BaseForm constructor.
     */
    public function __construct()
    {
        $this->masterkey = new MasterkeyFinder();
    }

    /**
     * @return Disclaimer
     */
    public function getDisclaimer()
    {
        return $this->disclaimer;
    }

    /**
     * @param string $form_id
     */
    public function setFormID(string $form_id)
    {
        $this->formID = $form_id;
    }

    /** @return string */
    public function getFormID()
    {
        return $this->formID;
    }

    /**
     * @return BaseForm
     */
    public function getForm()
    {
        return $this;
    }

    /**
     * @param array
     * @return array
     */
    public function getFields()
    {
        return $this->fields;
    }

    /**
     * @return bool
     */
    public function isEnable(): bool
    {
        return $this->enable;
    }

    /**
     * @param bool $enable
     * @return $this
     */
    public function setEnable(bool $enable)
    {
        $this->enable = $enable;
        return $this;
    }

    /**
     * @return string
     */
    public function getDisclaimerID()
    {
        return $this->disclaimer_id;
    }

    /**
     * @param int $disclaimer_id
     * @return $this
     */
    public function setDisclaimerID(int $disclaimer_id)
    {
        $this->disclaimer_id = $disclaimer_id;
        return $this;
    }

    /**
     * @return array
     */
    public function getCTA()
    {
        return $this->cta;
    }

    /**
     * @param array $cta
     * @return $this
     */
    public function setCTA(array $cta)
    {
        $this->cta = $cta;
        return $this;
    }

    /**
     * @return string
     */
    public function getBrandID()
    {
        return (string) $this->brand_id;
    }

    /**
     * @param string $brand_id
     * @return $this
     */
    public function setBrandID(string $brand_id)
    {
        $this->brand_id = $brand_id;
        return $this;
    }

    /**
     * @return int
     */
    public function getCID()
    {
        return $this->cid;
    }

    /**
     * @param int $cid
     * @return $this
     */
    public function setCID(int $cid)
    {
        $this->cid = $cid;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getOID()
    {
        return $this->oid;
    }

    /**
     * @param int $oid
     * @return $this
     */
    public function setOID(int $oid)
    {
        $this->oid = $oid;
        return $this;
    }

    /**
     * @return string
     */
    public function getSource()
    {
        return $this->source;
    }

    /**
     * @param string $source
     * @return $this
     */
    public function setSource(string $source)
    {
        $this->source = $source;
        return $this;
    }

    /**
     * @return CacheInterface
     */
    public function getCache()
    {
        return $this->cache;
    }

    /**
     * @param CacheInterface $cache
     * @return $this
     */
    public function setCache(CacheInterface $cache)
    {
        $this->cache = $cache;
        return $this;
    }

    /**
     * @return LoggerInterface
     */
    public function getLogger()
    {
        return $this->logger;
    }

    /**
     * @param LoggerInterface $logger
     * @return $this
     */
    public function setLogger(LoggerInterface $logger)
    {
        $this->logger = $logger;
        return $this;
    }

    /**
     * @return bool
     */
    public function withDealers()
    {
        return $this->with_dealers;
    }

    /**
     * @param bool $state
     * @return $this
     */
    public function setWithDealers(bool $state)
    {
        $this->with_dealers = $state;
        return $this;
    }

    /**
     * @return array|bool
     */
    public function getDealersList()
    {
        return $this->dealers_list;
    }

    /**
     * @return bool
     */
    public function withSubDealers()
    {
        return $this->with_sub_dealers;
    }


    /**
     * @param bool $state
     * @return $this
     */
    public function setWithSubDealers(bool $state)
    {
        $this->with_sub_dealers = $state;
        return $this;
    }



    public function setDealersList(array $dealers)
    {
        $this->dealers_list = $dealers;
        return $this;
    }

    /**
     * @return string
     */
    public function getHelpersCachePath()
    {
        return $this->helpers_cache_path;
    }

    /**
     * @return string
     */
    public function setHelpersCachePath($helpers_cache_path)
    {
        $this->helpers_cache_path = $helpers_cache_path;
        return $this;
    }

    /**
     * @param array $form
     */
    public function initForm(array $form)
    {
        // Overwrite in Form class
    }

    /**
     * @param array $form_data
     */
    public function setFormData(array $form_data)
    {
        $this->form_data = new FormData($form_data);
    }

    /**
     * @return array
     */
    public function getFormAbsentFields()
    {
        return $this->form_data_absent_fields;
    }

    /**
     * @return array|null
     */
    public function getFormErrors()
    {
        return $this->form_data_errors;
    }

    /**
     * @return bool
     */
    public function isFormDataValid()
    {
        return !((bool) count($this->getFormErrors()) or (bool) count($this->getFormAbsentFields()));
    }

    /**
     * @return ClientParamInterface
     */
    public function getClientParams()
    {
        return $this->client_params;
    }

    /**
     * @param ClientParamInterface $client_params
     * @return $this
     */
    public function setClientParams(ClientParamInterface $client_params)
    {
        $this->client_params = $client_params;
        return $this;
    }
}
