<?php

namespace FCAPoland\FormsLib\Form;

use FCAPoland\FormsLib\Field\FieldInterface;

/**
 * Class FormData
 * @package FCAPoland\FormsLib\Form
 */
class FormData
{
    /**
     * List of object's properties that can be directly returned when invoking `asArray()` method
     *
     * @var array
     */
    protected $properties = array();

    /**
     * FormData constructor.
     * @param $form_data
     */
    public function __construct($form_data)
    {
        $this->properties = $form_data;
        return $this;
    }

    /**
     * @param $form_data
     * @return FormData
     */
    public function setProperties($form_data)
    {
        $this->properties = $form_data;
        return $this;
    }

    /**
     * Get property like 'cta', 'firstname'
     *
     * @param $name
     *
     * @return mixed|null
     */
    private function getProperty($name)
    {
        return array_key_exists($name, $this->properties) ? $this->properties[$name] : null;
    }

    /**
     * Get property by Field
     *
     * @param FieldInterface $field
     * @return mixed|null
     */
    public function getPropertyByField(FieldInterface $field)
    {
        return array_key_exists($field->getName(), $this->properties) ? $this->properties[$field->getName()] : null;
    }

    /**
     * Get all properties
     *
     * @return mixed|null
     */
    public function getProperties()
    {
        return $this->properties;
    }

    /**
     * Has property like 'cta', 'firstname'
     *
     * @param $name
     *
     * @return bool
     */
    public function hasProperty($name)
    {
        return array_key_exists($name, $this->properties) ? true : false;
    }

    /**
     * @return mixed|null
     */
    public function getCTA()
    {
        return $this->getProperty('cta');
    }

    /**
     * @return mixed|null
     */
    public function getBrandID()
    {
        return $this->getProperty('brand_id');
    }

    /**
     * @return mixed|null
     */
    public function getModelID()
    {
        return $this->getProperty('model_id');
    }

    /**
     * @return mixed|null
     */
    public function getFirstName()
    {
        return $this->getProperty('firstname');
    }

    /**
     * @return mixed|null
     */
    public function getLastName()
    {
        return $this->getProperty('lastname');
    }

    /**
     * @return mixed|null
     */
    public function getEmail()
    {
        return $this->getProperty('email');
    }

    /**
     * @return mixed|null
     */
    public function getAddress()
    {
        return $this->getProperty('address');
    }

    /**
     * @return mixed|null
     */
    public function getCity()
    {
        return $this->getProperty('city');
    }

    /**
     * @return mixed|null
     */
    public function getZipCode()
    {
        return $this->getProperty('zipcode');
    }

    /**
     * @return mixed|null
     */
    public function getCompany()
    {
        return $this->getProperty('company');
    }

    /**
     * @return mixed|null
     */
    public function getPhone()
    {
        return $this->getProperty('phone');
    }

    /**
     * @return mixed|null
     */
    public function getDealerSincom()
    {
        return $this->getProperty('dealer_sincom');
    }

    /**
     * @return mixed|null
     */
    public function getAppointmentDate()
    {
        return $this->getProperty('appointment_date');
    }

    /**
     * @return mixed|null
     */
    public function getRelatedID()
    {
        return $this->getProperty('related_id');
    }

    /**
     * @return mixed|null
     */
    public function getOrigin()
    {
        return $this->getProperty('origin');
    }

    /**
     * @return mixed|null
     */
    public function getUserAgent()
    {
        return $this->getProperty('user_agent');
    }

    /**
     * @return mixed|null
     */
    public function getDevice()
    {
        return $this->getProperty('device');
    }

    /**
     * @return mixed|null
     */
    public function getIP()
    {
        return $this->getProperty('ip');
    }

    /**
     * @return mixed|null
     */
    public function getComment()
    {
        return $this->getProperty('comment');
    }

    /**
     * @return mixed|null
     */
    public function getCommunicationChannel()
    {
        return $this->getProperty('communication_channel');
    }

    /**
     * @param $key
     * @return mixed|null
     */
    public function getAgreementByKey($key)
    {
        return $this->getProperty($key);
    }
}
