<?php

namespace FCAPoland\FormsLib\ClientParam;

/**
 * Class SessionClientParam
 * @package FCAPoland\FormsLib\ClientParam
 */
class SessionClientParam extends BaseClientParam
{

    /**
     * SessionClientParam constructor.
     */
    public function __construct()
    {
        if (session_status() != PHP_SESSION_ACTIVE) {
            session_start();
        }

        if (isset($_SESSION[self::PARAM_CID])) {
            $this->setCID($_SESSION[self::PARAM_CID]);
        }
        if (isset($_SESSION[self::PARAM_OID])) {
            $this->setOID($_SESSION[self::PARAM_OID]);
        }
        if (isset($_SESSION[self::PARAM_SOURCE])) {
            $this->setSource($_SESSION[self::PARAM_SOURCE]);
        }
        if (isset($_SESSION[self::PARAM_CAMPAIGN_ID])) {
            $this->setCampaignID($_SESSION[self::PARAM_CAMPAIGN_ID]);
        }
        if (isset($_SESSION[self::PARAM_OFFER_ID])) {
            $this->setOfferID($_SESSION[self::PARAM_OFFER_ID]);
        }
        if (isset($_SESSION[self::PARAM_BANNER_ID])) {
            $this->setBannerID($_SESSION[self::PARAM_BANNER_ID]);
        }
        if (isset($_SESSION[self::PARAM_ADVERTISER_ID])) {
            $this->setAdvertiserID($_SESSION[self::PARAM_ADVERTISER_ID]);
        }
        if (isset($_SESSION[self::PARAM_PUBLISHER])) {
            $this->setPublisher($_SESSION[self::PARAM_PUBLISHER]);
        }
    }

    /**
     * @param $value
     * @return $this|ClientParamInterface
     */
    public function setCID($value)
    {
        if (!empty($value) and $value != $this->getCID()) {
            $_SESSION[self::PARAM_CID] = $value;
            return parent::setCID($value);
        }
        return $this;
    }

    /**
     * @param $value
     * @return $this|ClientParamInterface
     */
    public function setOID($value)
    {
        if (!empty($value) and $value != $this->getOID()) {
            $_SESSION[self::PARAM_OID] = $value;
            return parent::setOID($value);
        }
        return $this;
    }

    /**
     * @param $value
     * @return $this|ClientParamInterface
     */
    public function setSource($value)
    {
        if (!empty($value) and $value != $this->getSource()) {
            $_SESSION[self::PARAM_SOURCE] = $value;
            return parent::setSource($value);
        }
        return $this;
    }

    /**
     * @param $value
     * @return $this|ClientParamInterface
     */
    public function setCampaignID($value)
    {
        if (!empty($value) and $value != $this->getCampaignID()) {
            $_SESSION[self::PARAM_CAMPAIGN_ID] = $value;
            return parent::setCampaignID($value);
        }
        return $this;
    }

    /**
     * @param $value
     * @return $this|ClientParamInterface
     */
    public function setOfferID($value)
    {
        if (!empty($value) and $value != $this->getOfferID()) {
            $_SESSION[self::PARAM_OFFER_ID] = $value;
            return parent::setOfferID($value);
        }
        return $this;
    }

    /**
     * @param $value
     * @return $this|ClientParamInterface
     */
    public function setBannerID($value)
    {
        if (!empty($value) and $value != $this->getBannerID()) {
            $_SESSION[self::PARAM_BANNER_ID] = $value;
            return parent::setBannerID($value);
        }
        return $this;
    }

    /**
     * @param $value
     * @return $this|ClientParamInterface
     */
    public function setAdvertiserID($value)
    {
        if (!empty($value) and $value != $this->getAdvertiserID()) {
            $_SESSION[self::PARAM_ADVERTISER_ID] = $value;
            return parent::setAdvertiserID($value);
        }
        return $this;
    }

    /**
     * @param $value
     * @return $this|ClientParamInterface
     */
    public function setPublisher($value)
    {
        if (!empty($value) and $value != $this->getPublisher()) {
            $_SESSION[self::PARAM_PUBLISHER] = $value;
            return parent::setPublisher($value);
        }
        return $this;
    }
}
