<?php

namespace FCAPoland\FormsLib\Config;

use FCAPoland\FormsLib\Exception\InvalidArgumentException;

/**
 * Class FcaApiAuth
 * @package FCAPoland\FormsLib\Config
 */
class FCAAPIAuth extends BaseConfig
{
    /** @var String */
    private $api_url;

    /** @var String */
    private $api_user;

    /** @var String */
    private $api_pass;

    /**
     * @param array $config
     * @return mixed|void
     * @throws InvalidArgumentException
     */
    public function setConfig(array $config)
    {
        parent::setConfig($config);

        if (!isset($config['api_url']) or !isset($config['api_user']) or !isset($config['api_pass'])) {
            throw new InvalidArgumentException('FCA LEAD API INCORRECT');
        }

        try {
            $this->setApiUrl($config['api_url']);
            $this->setApiUser($config['api_user']);
            $this->setApiPass($config['api_pass']);
        } catch (\TypeError $e) {
            throw new InvalidArgumentException('FCA LEAD API INCORRECT: ' . $e->getMessage());
        }
    }

    /**
     * @return String
     */
    public function getApiUrl(): String
    {
        return $this->api_url;
    }

    /**
     * @param String $api_url
     */
    private function setApiUrl(String $api_url)
    {
        $this->api_url = $api_url;
    }

    /**
     * @return String
     */
    public function getApiUser(): String
    {
        return $this->api_user;
    }

    /**
     * @param String $api_user
     */
    private function setApiUser(String $api_user)
    {
        $this->api_user = $api_user;
    }

    /**
     * @return String
     */
    public function getApiPass(): String
    {
        return $this->api_pass;
    }

    /**
     * @param String $api_pass
     */
    private function setApiPass(String $api_pass)
    {
        $this->api_pass = $api_pass;
    }
}
