<?php

namespace FCAPoland\FormsLib\ClientParam;

/**
 * Class SessionClientParam
 * @package FCAPoland\FormsLib\ClientParam
 */
class SessionClientParam extends BaseClientParam
{

    /**
     * SessionClientParam constructor.
     */
    public function __construct()
    {
        if (session_status() != PHP_SESSION_ACTIVE) {
            session_start();
        }

        if (isset($_SESSION[self::PARAM_CID])) {
            $this->setCID($_SESSION[self::PARAM_CID]);
        }
        if (isset($_SESSION[self::PARAM_OID])) {
            $this->setOID($_SESSION[self::PARAM_OID]);
        }
        if (isset($_SESSION[self::PARAM_SOURCE])) {
            $this->setSource($_SESSION[self::PARAM_SOURCE]);
        }
    }

    /**
     * @param $value
     * @return $this|ClientParamInterface
     */
    public function setCID($value)
    {
        if (!empty($value) and $value != $this->getCID()) {
            $_SESSION[self::PARAM_CID] = $value;
            return parent::setCID($value);
        }
        return $this;
    }

    /**
     * @param $value
     * @return $this|ClientParamInterface
     */
    public function setOID($value)
    {
        if (!empty($value) and $value != $this->getOID()) {
            $_SESSION[self::PARAM_OID] = $value;
            return parent::setOID($value);
        }
        return $this;
    }

    /**
     * @param $value
     * @return $this|ClientParamInterface
     */
    public function setSource($value)
    {
        if (!empty($value) and $value != $this->getSource()) {
            $_SESSION[self::PARAM_SOURCE] = $value;
            return parent::setSource($value);
        }
        return $this;
    }
}
