<?php

namespace FCAPoland\FormsLib\Field\Rule;

use FCAPoland\FormsLib\Field\FieldInterface;
use FCAPoland\FormsLib\Message;

/**
 * Class BaseRule
 * @package FCAPoland\FormsLib\Field\Rule
 */
class BaseRule implements RuleInterface
{
    /**
     * @var string
     */
    protected $regex;


    /** @var FieldInterface */
    protected $field;

    /**
     * @param $value
     * @return bool
     */
    public function isValidValue($value)
    {
        return (bool) preg_match($this->regex, $value);
    }

    /**
     * @param $regex
     * @return void
     */
    public function setRegex($regex)
    {
        $this->regex = $regex;
    }

    /**
     * @return mixed
     */
    public function getRegex()
    {
        return $this->regex;
    }

    /**
     * @return string
     */
    public function getRuleName()
    {
        $path = explode('\\', get_class($this));
        return array_pop($path);
    }

    /**
     * @return string
     */
    public function getFieldName()
    {
        return $this->field->getFieldName();
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return Message::getInstance()->getMessageFor($this);
    }
}
