<?php

namespace FCAPoland\FormsLib\ClientParam;

/**
 * Interface ClientParamInterface
 * @package FCAPoland\FormsLib\ClientParam
 */
interface ClientParamInterface
{
    const PARAM_CID = 'cp_cid';
    const PARAM_OID = 'cp_oid';
    const PARAM_SOURCE = 'cp_source';

    /**
     * Param getter
     * @param $key
     * @return string|null
     */
    public function getParam($key);

    /**
     * @return string|null
     */
    public function getCID();

    /**
     * @return string|null
     */
    public function getOID();

    /**
     * @return string|null
     */
    public function getSource();

    /**
     * Param setter
     * @param $kay
     * @param $value
     * @return $this
     */
    public function setParam($kay, $value);

    /**
     * @param $value
     * @return $this
     */
    public function setCID($value);

    /**
     * @param $value
     * @return $this
     */
    public function setOID($value);

    /**
     * @param $value
     * @return $this
     */
    public function setSource($value);
}
