<?php

namespace FCAPoland\FormsLib\Field;

use FCAPoland\FormsLib\Field\Rule\InArray;
use FCAPoland\FormsLib\Field\Rule\NotEmpty;

/**
 * Class ModelIDField
 * @package FCAPoland\FormsLib\Field
 */
class ModelIDField extends BaseField
{
    /**
     * @var string
     */
    protected $type = BaseField::TYPE_SELECT;

    /**
     * @var string
     */
    protected $name = 'model_id';

    /**
     * @var string
     */
    protected $label = 'Model';

    /**
     * ModelIDField constructor.
     * @param $type
     * @param $options
     */
    public function __construct($type, $options = null)
    {
        $this->setOptionValues($options);
        $this->setDefaultRules();
        $this->setType($type);
    }

    /**
     * Set default rules for this field
     */
    protected function setDefaultRules()
    {
        if (!is_array($this->getOptionValues()) and is_string($this->getOptionValues())) {
            $this->setOptionValues([$this->getOptionValues()]);
        }

        $this->setRules(
            [
                NotEmpty::class => [],
                InArray::class => [array_keys($this->getOptionValues())]
            ]
        );
    }
}
