<?php

namespace FCAPoland\FormsLib\Field;

use FCAPoland\FormsLib\Field\Rule\MaxLength;
use FCAPoland\FormsLib\Field\Rule\NotEmpty;

/**
 * Class CityField
 * @package FCAPoland\FormsLib\Field
 */
class CityField extends BaseField
{
    /**
     * @var string
     */
    protected $type = BaseField::TYPE_TEXT;

    /**
     * @var string
     */
    protected $name = 'email';

    /** @var bool */
    protected $required = true;

    /**
     * @var string
     */
    protected $place_holder = 'E-mail';

    /**
     * FirstNameField constructor.
     */
    public function __construct()
    {
        $this->setDefaultRules();
    }

    /**
     * Set default rules for this field
     */
    protected function setDefaultRules()
    {
        if (!is_array($this->getOptionValues()) and is_string($this->getOptionValues())) {
            $this->setOptionValues([$this->getOptionValues()]);
        }

        $this->setRules(
            [
                NotEmpty::class => [],
                MaxLength::class => [100],
            ]
        );
    }
}
