<?php

namespace FCAPoland\FormsLib\Field;

/**
 * Interface FieldInterface
 * @package FCAPoland\FormsLib\Field
 */
interface FieldInterface
{
    /**
     * Get rules array
     * @return mixed
     */
    public function getRules();

    /**
     * @return array
     */
    public function getRuleObjects();

    /**
     * @return string
     */
    public function getType();

    /**
     * @return string
     */
    public function getName();

    /**
     * @return string|null
     */
    public function getLabel();

    /**
     * @return string|null
     */
    public function getPlaceHolder();

    /**
     * @return bool
     */
    public function isRequired();

    /**
     * @return string|null
     */
    public function getFormat();

    /**
     * @return array|null
     */
    public function getOptionValues();

    /**
     * Rules setter
     * @param $rules
     */
    public function setRules($rules);

    /**
     * @param $type
     * @return void
     */
    public function setType($type);

    /**
     * @param $name
     * @return void
     */
    public function setName($name);

    /**
     * @param $label
     * @return void
     */
    public function setLabel($label);

    /**
     * @param $place_holder
     * @return void
     */
    public function setPlaceHolder($place_holder);

    /**
     * @param $required
     * @return void
     */
    public function setRequired($required);

    /**
     * @param $format
     * @return void
     */
    public function setFormat($format);

    /**
     * @param $options
     * @return void
     */
    public function setOptionValues($options);

    /**
     * Check if value is valid
     * @param $value
     * @return bool
     */
    public function isValid($value);

    /**
     * @return mixed
     */
    public function initRules();

    /**
     * @return static
     */
    public function getFieldName();

    /**
     * @return mixed
     */
    public function getErrorsMessages();
}
