<?php

namespace FCAPoland\FormsLib\ClientParam;

/**
 * Class BaseClientParam
 *
 * @package FCAPoland\FormsLib\ClientParam
 *
 */
class BaseClientParam implements ClientParamInterface
{
    /**
     * @var array
     */
    protected $storage = [];

    /**
     * Param getter
     * @param $key
     * @return string|null
     */
    public function getParam($key)
    {
        return isset($this->storage[$key]) ? $this->storage[$key] : null;
    }

    /**
     * @return string|null
     */
    public function getCID()
    {
        return isset($this->storage[self::PARAM_CID]) ? $this->storage[self::PARAM_CID] : null;
    }

    /**
     * @return string|null
     */
    public function getOID()
    {
        return isset($this->storage[self::PARAM_OID]) ? $this->storage[self::PARAM_OID] : null;
    }

    /**
     * @return string|null
     */
    public function getSource()
    {
        return isset($this->storage[self::PARAM_SOURCE]) ? $this->storage[self::PARAM_SOURCE] : null;
    }

    /**
     * Param setter
     * @param $kay
     * @param $value
     * @return $this
     */
    public function setParam($kay, $value)
    {
        $this->storage[$kay] = $value;
        return $this;
    }

    /**
     * @param $value
     * @return $this
     */
    public function setCID($value)
    {
        return $this->setParam(self::PARAM_CID, $value);
    }

    /**
     * @param $value
     * @return $this
     */
    public function setOID($value)
    {
        return $this->setParam(self::PARAM_OID, $value);
    }

    /**
     * @param $value
     * @return $this
     */
    public function setSource($value)
    {
        return $this->setParam(self::PARAM_SOURCE, $value);
    }
}
