<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\ClientParam;

/**
 * Interface ClientParamInterface
 * @package FCAPoland\FormsLib\ClientParam
 */
interface ClientParamInterface
{
    const PARAM_CID = 'cp_cid';
    const PARAM_OID = 'cp_oid';
    const PARAM_SOURCE = 'cp_source';

    const PARAM_CAMPAIGN_ID = 'cp_campaignid';
    const PARAM_OFFER_ID = 'cp_offerid';
    const PARAM_BANNER_ID = 'cp_bannerid';
    const PARAM_ADVERTISER_ID = 'cp_advertiserid';
    const PARAM_PUBLISHER = 'cp_publisher';

    /**
     * Param getter
     * @param $key
     * @return string|null
     */
    public function getParam($key);

    /**
     * @return string|null
     */
    public function getCID();

    /**
     * @return string|null
     */
    public function getOID();

    /**
     * @return string|null
     */
    public function getSource();

    /**
     * @return string|null
     */
    public function getCampaignID();

    /**
     * @return string|null
     */
    public function getOfferID();

    /**
     * @return string|null
     */
    public function getBannerID();

    /**
     * @return string|null
     */
    public function getAdvertiserID();

    /**
     * @return string|null
     */
    public function getPublisher();

    /**
     * Param setter
     * @param $kay
     * @param $value
     * @return $this
     */
    public function setParam($kay, $value);

    /**
     * @param $value
     * @return $this
     */
    public function setCID($value);

    /**
     * @param $value
     * @return $this
     */
    public function setOID($value);

    /**
     * @param $value
     * @return $this
     */
    public function setSource($value);

    /**
     * @param $value
     * @return $this
     */
    public function setCampaignID($value);

    /**
     * @param $value
     * @return $this
     */
    public function setOfferID($value);

    /**
     * @param $value
     * @return $this
     */
    public function setBannerID($value);

    /**
     * @param $value
     * @return $this
     */
    public function setAdvertiserID($value);

    /**
     * @param $value
     * @return $this
     */
    public function setPublisher($value);

    /**
     * @return array
     */
    public function getAllParams();
}
