<?php


namespace Unit;


use FCAPoland\FormsLib\ClientParam\BaseClientParam;
use FCAPoland\FormsLib\ClientParam\ClientParamInterface;
use PHPUnit\Framework\TestCase;

/**
 * Class ClientParamTest
 * @package Unit
 */
class ClientParamTest extends TestCase
{
    public function testStorageObject()
    {
        $object = new BaseClientParam();
        $this->assertInstanceOf(ClientParamInterface::class, $object);
    }

    public function testEmptyObject()
    {
        $object = new BaseClientParam();
        $this->assertNull($object->getCID());
        $this->assertNull($object->getOID());
        $this->assertNull($object->getSource());
        $this->assertNull($object->getOfferID());
        $this->assertNull($object->getCampaignID());
        $this->assertNull($object->getBannerID());
        $this->assertNull($object->getPublisher());
        $this->assertNull($object->getAdvertiserID());
        $this->assertNull($object->getParam('test'));
        $this->assertIsArray($object->getAllParams());
    }

    public function testSetters()
    {
        $object = new BaseClientParam();
        $this->assertNull($object->getCID());
        $this->assertNull($object->getOID());
        $this->assertNull($object->getSource());
        $this->assertNull($object->getOfferID());
        $this->assertNull($object->getCampaignID());
        $this->assertNull($object->getBannerID());
        $this->assertNull($object->getPublisher());
        $this->assertNull($object->getAdvertiserID());
        $this->assertNull($object->getParam('test'));
        $this->assertIsArray($object->getAllParams());

        $object->setCID('cid_test');
        $object->setOID('oid_test');
        $object->setSource('source_test');
        $object->setOfferID('offer_test');
        $object->setCampaignID('campaign_test');
        $object->setBannerID('banner_test');
        $object->setPublisher('publisher_test');
        $object->setAdvertiserID('advert_test');
        $object->setParam('test', 'value_test');

        $this->assertEquals('cid_test', $object->getCID());
        $this->assertEquals('oid_test', $object->getOID());
        $this->assertEquals('source_test', $object->getSource());
        $this->assertEquals('offer_test', $object->getOfferID());
        $this->assertEquals('campaign_test', $object->getCampaignID());
        $this->assertEquals('banner_test', $object->getBannerID());
        $this->assertEquals('publisher_test', $object->getPublisher());
        $this->assertEquals('advert_test', $object->getAdvertiserID());
        $this->assertEquals('value_test', $object->getParam('test'));

    }

    public function testClear()
    {
        $object = new BaseClientParam();
        $this->assertNull($object->getCID());
        $object->setCID('cid_test');
        $this->assertNotNull($object->getCID());
        $object->clear();
        $this->assertNull($object->getCID());
    }
}