<?php


namespace Unit;


use FCAPoland\FormsLib\Field\FirstNameField;
use FCAPoland\FormsLib\Form\FormData;
use FCAPoland\LeadsAPIHelper\Lead;
use PHPUnit\Framework\TestCase;

/**
 * Class FormDataTest
 * @package Unit
 */
class FormDataTest extends TestCase
{
    public function testEmptyFormData()
    {
        $object = new FormData([]);
        $this->assertNull($object->getPropertyByField(new FirstNameField()));
        $this->assertFalse($object->hasProperty('1'));
        $this->assertNull($object->getCTA());
        $this->assertNull($object->getBrandID());
        $this->assertNull($object->getModelID());
        $this->assertNull($object->getFirstName());
        $this->assertNull($object->getLastName());
        $this->assertNull($object->getEmail());
        $this->assertNull($object->getAddress());
        $this->assertNull($object->getCity());
        $this->assertNull($object->getZipCode());
        $this->assertNull($object->getCompany());
        $this->assertNull($object->getPhone());
        $this->assertNull($object->getDealerSincom());
        $this->assertNull($object->getAppointmentDate());
        $this->assertNull($object->getRelatedID());
        $this->assertNull($object->getOrigin());
        $this->assertNull($object->getUserAgent());
        $this->assertNull($object->getDevice());
        $this->assertNull($object->getIP());
        $this->assertNull($object->getComment());
        $this->assertNull($object->getCommunicationChannel());
        $this->assertNull($object->getAgreementByKey(1));
    }

    public function testFilledFormData()
    {
        $object = new FormData([
            'cta'=>'TD',
            'brand_id' => '77',
            'model_id' => '150',
            'firstname' => 'Imie',
            'lastname' => 'Nazwisko',
            'email' => 'support@unicorn.net.pl',
            'address' => 'XXX',
            'city' => 'Prg',
            'zipcode' => '83-000',
            'company' => 'Firma',
            'phone' => '+48 000-000-000',
            'dealer_sincom' => '1111111.000',
            'appointment_date' => '20-02-2020',
            'related_id' => 1,
            'origin' => '...',
            'user_agent' => 'UserAgent',
            'device' => 'Mobile',
            'ip' => '0.0.0.0',
            'comment' => 'Com test',
            'communication_channel' => Lead::COMMUNICATION_CHANNEL_TELEPHONE,
            'agg_test' => 'test',
        ]);
        $this->assertFalse($object->hasProperty('agg_test2'));
        $this->assertTrue($object->hasProperty('agg_test'));
        $this->assertNotNull($object->getCTA());
        $this->assertNotNull($object->getBrandID());
        $this->assertNotNull($object->getModelID());
        $this->assertNotNull($object->getFirstName());
        $this->assertNotNull($object->getLastName());
        $this->assertNotNull($object->getEmail());
        $this->assertNotNull($object->getAddress());
        $this->assertNotNull($object->getCity());
        $this->assertNotNull($object->getZipCode());
        $this->assertNotNull($object->getCompany());
        $this->assertNotNull($object->getPhone());
        $this->assertNotNull($object->getDealerSincom());
        $this->assertNotNull($object->getAppointmentDate());
        $this->assertNotNull($object->getRelatedID());
        $this->assertNotNull($object->getOrigin());
        $this->assertNotNull($object->getUserAgent());
        $this->assertNotNull($object->getDevice());
        $this->assertNotNull($object->getIP());
        $this->assertNotNull($object->getComment());
        $this->assertNotNull($object->getCommunicationChannel());
        $this->assertNotNull($object->getAgreementByKey('agg_test'));

        $this->assertEquals('TD', $object->getCTA());
        $this->assertEquals('77', $object->getBrandID());
        $this->assertEquals('150', $object->getModelID());
        $this->assertEquals('Imie', $object->getFirstName());
        $this->assertEquals('Nazwisko', $object->getLastName());
        $this->assertEquals('support@unicorn.net.pl', $object->getEmail());
        $this->assertEquals('XXX', $object->getAddress());
        $this->assertEquals('Prg', $object->getCity());
        $this->assertEquals('83-000', $object->getZipCode());
        $this->assertEquals('Firma', $object->getCompany());
        $this->assertEquals('+48 000-000-000', $object->getPhone());
        $this->assertEquals('1111111.000', $object->getDealerSincom());
        $this->assertEquals('20-02-2020', $object->getAppointmentDate());
        $this->assertEquals(1, $object->getRelatedID());
        $this->assertEquals('...', $object->getOrigin());
        $this->assertEquals('UserAgent', $object->getUserAgent());
        $this->assertEquals('Mobile', $object->getDevice());
        $this->assertEquals('0.0.0.0', $object->getIP());
        $this->assertEquals('Com test', $object->getComment());
        $this->assertEquals(Lead::COMMUNICATION_CHANNEL_TELEPHONE, $object->getCommunicationChannel());
        $this->assertEquals('test', $object->getAgreementByKey('agg_test'));
    }
}