<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field\Rule;

use FCAPoland\FormsLib\Field\FieldInterface;

/**
 * Interface RuleInterface
 * @package FCAPoland\FormsLib\Field\Rule
 */
interface RuleInterface
{
    /**
     * @param $value
     * @return bool
     */
    public function isValidValue($value);

    /**
     * @param $regex
     * @return void
     */
    public function setRegex($regex);

    /**
     * @return mixed
     */
    public function getRegex();

    /**
    string
     */
    public function getRuleName();

    /**
     * @return string|null
     */
    public function getFieldName();

    /**
     * @return FieldInterface|null
     */
    public function getField();

    /**
     * @return string
     */
    public function getMessage();
}
