<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field\Rule;

use FCAPoland\FormsLib\Field\FieldInterface;
use FCAPoland\FormsLib\Message;

/**
 * Class BaseRule
 * @package FCAPoland\FormsLib\Field\Rule
 */
class BaseRule implements RuleInterface
{
    /**
     * @var string
     */
    protected $regex;


    /** @var FieldInterface */
    protected $field;

    /**
     * BaseRule constructor.
     * @param FieldInterface $field
     */
    public function __construct(FieldInterface $field)
    {
        $this->field = $field;
    }

    /**
     * @param $value
     * @return bool
     */
    public function isValidValue($value)
    {
        // Zabezpieczenie na nieprzekazanie wartości z pola.
        // np wymagane pole od marki (brand_id) nie jest przekazane czyli w domyśle ma wartość null
        // Dodatkowo sprawdzane jest czy wartość walidowana jest stringiem, dla preg_match to ważne.
        if ($this->field->isRequired() and ($value === null or !is_string($value) and !is_int($value))) {
            return false;
        }
        // preg_match przyjmuje jako 2 parametr stringi
        return (bool) preg_match($this->regex, (string) $value);
    }

    /**
     * @param $regex
     * @return void
     */
    public function setRegex($regex)
    {
        $this->regex = $regex;
    }

    /**
     * @return mixed
     */
    public function getRegex()
    {
        return $this->regex;
    }

    /**
     * @return string
     */
    public function getRuleName()
    {
        //$path = explode('\\', get_class($this));
        return get_class($this);
    }

    /**
     * @return string
     */
    public function getFieldName()
    {
        return $this->field->getFieldName();
    }

    /**
     * @return FieldInterface|null
     */
    public function getField()
    {
        return $this->field;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return Message::getInstance()->getMessageFor($this);
    }
}
