<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field;

/**
 * Interface FieldInterface
 * @package FCAPoland\FormsLib\Field
 */
interface FieldInterface
{
    /**
     * Get field value array
     * @return mixed
     */
    public function getValue();

    /**
     * Get rules array
     * @return mixed
     */
    public function getRules(): array;

    /**
     * @return array
     */
    public function getRuleObjects(): array;

    /**
     * @return string
     */
    public function getType(): string;

    /**
     * @return string
     */
    public function getName(): string;

    /**
     * @return string|null
     */
    public function getLabel(): ?string;

    /**
     * @return string|null
     */
    public function getPlaceHolder(): ?string;

    /**
     * @return bool
     */
    public function isRequired(): bool;

    /**
     * @return string|null
     */
    public function getFormat(): ?string;

    /**
     * @return array|null
     */
    public function getOptionValues(): ?array;

    /**
     * Value setter
     * @param $value
     */
    public function setValue($value);

    /**
     * Rules setter
     * @param array $rules
     */
    public function setRules(array $rules);

    /**
     * @param string $type
     * @return void
     */
    public function setType(string $type);

    /**
     * @param string $name
     * @return void
     */
    public function setName(string $name);

    /**
     * @param string $label
     * @return void
     */
    public function setLabel(string $label);

    /**
     * @param string $place_holder
     * @return void
     */
    public function setPlaceHolder(string $place_holder);

    /**
     * @param bool $required
     * @return void
     */
    public function setRequired(bool $required);

    /**
     * @param string $format
     * @return void
     */
    public function setFormat(string $format);

    /**
     * @param array $options
     * @return void
     */
    public function setOptionValues(array $options);

    /**
     * Check if value is valid
     * @param $value
     * @return bool
     */
    public function isValid($value);

    /**
     * @return mixed
     */
    public function initRules();

    /**
     * @return static
     */
    public function getFieldName();

    /**
     * @return mixed
     */
    public function getErrorsMessages();
}
