<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field;

use FCAPoland\FormsLib\Field\Rule\NotEmpty;
use FCAPoland\FormsLib\Field\Rule\ValidDealerSincom;

/**
 * Class DealerSincomField
 * @package FCAPoland\FormsLib\Field
 */
class DealerSincomField extends BaseField
{
    /**
     * @var string
     */
    protected $type = BaseField::TYPE_SELECT;

    /**
     * @var string
     */
    protected $name = 'dealer_sincom';

    /** @var bool */
    protected $required = true;

    /**
     * @var string
     */
    protected $place_holder = 'Wybierz dealera';

    /**
     * FirstNameField constructor.
     */
    public function __construct()
    {
        $this->setDefaultRules();
    }

    /**
     * Set default rules for this field
     */
    protected function setDefaultRules()
    {
        if (!is_array($this->getOptionValues()) and is_string($this->getOptionValues())) {
            $this->setOptionValues([$this->getOptionValues()]);
        }

        $this->setRules(
            [
                NotEmpty::class => [],
                ValidDealerSincom::class => [],
            ]
        );
    }
}
