<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Exception;

use Throwable;

/**
 * Class FormsLIBException
 * @package FCAPoland\FormsLib\Exception
 */
class FormsLIBException extends \Exception
{
    /**
     * FormsLIBException constructor.
     * @param string $message
     * @param int $code
     * @param Throwable|null $previous
     */
    public function __construct(string $message = "", int $code = 0, Throwable $previous = null)
    {
        $message = '[FORMS-LIB] ' . $message;
        parent::__construct($message, $code, $previous);
    }
}
