<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field\Rule;

use FCAPoland\FormsLib\Field\FieldInterface;

/**
 * Class MaxLength
 * @package FCAPoland\FormsLib\Field\Rule
 */
class MaxLength extends BaseRule
{
    /**
     * MaxLength constructor.
     * @param FieldInterface $field
     * @param $max_length
     */
    public function __construct(FieldInterface $field, $max_length)
    {
        parent::__construct($field);
        // Auto gen regex for $max_length
        $this->regex = "/^.{0,{$max_length}}$/";
    }
}
