<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\ClientParam;

/**
 * Class BaseClientParam
 *
 * @package FCAPoland\FormsLib\ClientParam
 *
 */
class BaseClientParam implements ClientParamInterface
{
    /**
     * @var array
     */
    protected $storage = [];

    /**
     * Param getter
     * @param $key
     * @return string|null
     */
    public function getParam($key)
    {
        return isset($this->storage[$key]) ? $this->storage[$key] : null;
    }

    /**
     * @return string|null
     */
    public function getCID()
    {
        return isset($this->storage[self::PARAM_CID]) ? $this->storage[self::PARAM_CID] : null;
    }

    /**
     * @return string|null
     */
    public function getOID()
    {
        return isset($this->storage[self::PARAM_OID]) ? $this->storage[self::PARAM_OID] : null;
    }

    /**
     * @return string|null
     */
    public function getSource()
    {
        return isset($this->storage[self::PARAM_SOURCE]) ? $this->storage[self::PARAM_SOURCE] : null;
    }

    /**
     * @inheritDoc
     */
    public function getCampaignID()
    {
        return isset($this->storage[self::PARAM_CAMPAIGN_ID]) ? $this->storage[self::PARAM_CAMPAIGN_ID] : null;
    }

    /**
     * @inheritDoc
     */
    public function getOfferID()
    {
        return isset($this->storage[self::PARAM_OFFER_ID]) ? $this->storage[self::PARAM_OFFER_ID] : null;
    }

    /**
     * @inheritDoc
     */
    public function getBannerID()
    {
        return isset($this->storage[self::PARAM_BANNER_ID]) ? $this->storage[self::PARAM_BANNER_ID] : null;
    }

    /**
     * @inheritDoc
     */
    public function getAdvertiserID()
    {
        return isset($this->storage[self::PARAM_ADVERTISER_ID]) ? $this->storage[self::PARAM_ADVERTISER_ID] : null;
    }

    /**
     * @inheritDoc
     */
    public function getPublisher()
    {
        return isset($this->storage[self::PARAM_PUBLISHER]) ? $this->storage[self::PARAM_PUBLISHER] : null;
    }

    /**
     * Param setter
     * @param $kay
     * @param $value
     * @return $this
     */
    public function setParam($kay, $value)
    {
        $this->storage[$kay] = $value;
        return $this;
    }

    /**
     * @param $value
     * @return $this
     */
    public function setCID($value)
    {
        return $this->setParam(self::PARAM_CID, $value);
    }

    /**
     * @param $value
     * @return $this
     */
    public function setOID($value)
    {
        return $this->setParam(self::PARAM_OID, $value);
    }

    /**
     * @param $value
     * @return $this
     */
    public function setSource($value)
    {
        return $this->setParam(self::PARAM_SOURCE, $value);
    }

    /**
     * @inheritDoc
     */
    public function setCampaignID($value)
    {
        return $this->setParam(self::PARAM_CAMPAIGN_ID, $value);
    }

    /**
     * @inheritDoc
     */
    public function setOfferID($value)
    {
        return $this->setParam(self::PARAM_OFFER_ID, $value);
    }

    /**
     * @inheritDoc
     */
    public function setBannerID($value)
    {
        return $this->setParam(self::PARAM_BANNER_ID, $value);
    }

    /**
     * @inheritDoc
     */
    public function setAdvertiserID($value)
    {
        return $this->setParam(self::PARAM_ADVERTISER_ID, $value);
    }

    /**
     * @inheritDoc
     */
    public function setPublisher($value)
    {
        return $this->setParam(self::PARAM_PUBLISHER, $value);
    }

    /**
     * @inheritDoc
     */
    public function getAllParams()
    {
        return [
            'cid' => $this->getCID(),
            'oid' => $this->getOID(),
            'source' => $this->getSource(),
            'campaignid' => $this->getCampaignID(),
            'offerid' => $this->getOfferID(),
            'bannerid' => $this->getBannerID(),
            'advertiserid' => $this->getAdvertiserID(),
            'publisher' => $this->getPublisher(),
        ];
    }

    public function clear()
    {
        $this->storage = [];
    }
}
