<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field;

use FCAPoland\FormsLib\Field\Rule\IsPhone;
use FCAPoland\FormsLib\Field\Rule\MaxLength;
use FCAPoland\FormsLib\Field\Rule\MinLength;
use FCAPoland\FormsLib\Field\Rule\NotEmpty;

/**
 * Class PhoneField
 * @package FCAPoland\FormsLib\Field
 */
class PhoneField extends BaseField
{
    /**
     * @var string
     */
    protected $type = BaseField::TYPE_TEXT;

    /**
     * @var string
     */
    protected $name = 'phone';

    /** @var bool */
    protected $required = true;

    /**
     * @var string
     */
    protected $format = '+48 999-999-999';

    /**
     * @var string
     */
    protected $place_holder = 'Numer telefonu';

    /**
     * FirstNameField constructor.
     */
    public function __construct()
    {
        $this->setDefaultRules();
    }

    /**
     * Set default rules for this field
     */
    protected function setDefaultRules()
    {
        if (!is_array($this->getOptionValues()) and is_string($this->getOptionValues())) {
            $this->setOptionValues([$this->getOptionValues()]);
        }

        $this->setRules(
            [
                NotEmpty::class => [],
                IsPhone::class => [],
                MinLength::class => [9],
                MaxLength::class => [20],
            ]
        );
    }
}
