<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Config;

/**
 * Class LibConfig
 * @package FCAPoland\FormsLib\Config
 */
class LibConfig extends BaseConfig
{
    /**
     * @return string
     */
    public function getStoragePath()
    {
        return $this->getConfig()['lead_api_cache'] ?? './cache_lead_api.cache';
    }

    /**
     * @return string|null
     */
    public function getPrivacyPolicyHash()
    {
        return $this->getConfig()['policy_hash'] ?? null;
    }

    /**
     * @return bool|array
     */
    public function getForms()
    {
        return $this->getConfig()['forms'] ?? null;
    }
}
