<?php


namespace Unit;

use FCAPoland\ApiPrivacyHelper\StorageInterface;
use FCAPoland\FormsLib\Storage;

/**
 * Class StorageTest
 * @package Unit
 */
class StorageTest extends \PHPUnit\Framework\TestCase
{

    public function testStorageObject()
    {
        $storage = new Storage(STORAGE_DIR);
        $this->assertInstanceOf(StorageInterface::class, $storage);
    }

    public function testEmptyStorage()
    {
        $storage = new Storage(STORAGE_DIR);
        $this->assertFalse($storage->getDealers('00'));
        $this->assertFalse($storage->getPrivacyPolicy('xxx'));
        $this->assertFalse($storage->getDisclaimer(666));
        $storage->removeStorage();
    }

    public function testNotEmpty()
    {
        $value = 'value';
        $value2 = 'value2';
        $value3 = 'value3';
        $value4 = 'value4';
        $storage = new Storage(STORAGE_DIR);

        $this->assertFalse($storage->getDealers('00'));
        $this->assertFalse($storage->getPrivacyPolicy('xxx'));
        $this->assertFalse($storage->getDisclaimer(666));
        $this->assertFalse($storage->readFromStorage('test'));

        $storage->saveDealers('00', $value);
        $storage->savePrivacyPolicy('xxx', $value2);
        $storage->saveDisclaimer(666, $value3);
        $storage->saveToStorage('test', $value4);
        $this->assertNotFalse($storage->getDealers('00'));
        $this->assertNotFalse($storage->getPrivacyPolicy('xxx'));
        $this->assertNotFalse($storage->getDisclaimer(666));
        $this->assertNotFalse($storage->readFromStorage('test'));

        $this->assertEquals($value, $storage->getDealers('00'));
        $this->assertNotFalse($value2, $storage->getPrivacyPolicy('xxx'));
        $this->assertNotFalse($value3, $storage->getDisclaimer(666));
        $this->assertNotFalse($value4, $storage->readFromStorage('test'));
        $storage->removeStorage();
    }
}