<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field;

use FCAPoland\FormsLib\Field\Rule\MaxLength;
use FCAPoland\FormsLib\Field\Rule\MinLength;
use FCAPoland\FormsLib\Field\Rule\NotEmpty;

/**
 * Class FirstNameField
 * @package FCAPoland\FormsLib\Field
 */
class FirstNameField extends BaseField
{
    /**
     * @var string
     */
    protected $type = BaseField::TYPE_TEXT;

    /**
     * @var string
     */
    protected $name = 'firstname';

    /**
     * @var string
     */
    protected $place_holder = 'Imię';

    /**
     * FirstNameField constructor.
     */
    public function __construct()
    {
        $this->setDefaultRules();
    }

    /**
     * Set default rules for this field
     */
    protected function setDefaultRules()
    {
        if (!is_array($this->getOptionValues()) and is_string($this->getOptionValues())) {
            $this->setOptionValues([$this->getOptionValues()]);
        }

        $this->setRules(
            [
                NotEmpty::class => [],
                MinLength::class => [2],
                MaxLength::class => [50],
            ]
        );
    }
}
