<?php


namespace Unit;


use FCAPoland\FormsLib\Config\ConfigInterface;
use FCAPoland\FormsLib\Config\LibConfig;
use FCAPoland\FormsLib\Field\CTAField;
use FCAPoland\LeadsAPIHelper\Lead;
use PHPUnit\Framework\TestCase;

/**
 * Class LibConfigTest
 * @package Unit
 */
class LibConfigTest extends TestCase
{
    protected $correct_config = [
        'lead_api_cache' => './xxx',
        'policy_hash' => 'sss',
        'forms' => [
            'offerFormTestDrive' => [
                'id' => 'offerFormTestDrive',
                'enabled' => true,
                'with_subdealers' => true,
                'disclaimer_id' => 723,
                'brand_id'  =>  '77',
                'cid'    =>  '7777',
                'oid'    =>  '7777',
                'source' =>  'dem',
                'fields' => [
                    CTAField::class => [Lead::TYPE_TESTDRIVE]
                ],
            ],
        ]
    ];

    public function testCreateObject()
    {
        $object = new LibConfig();
        $this->assertInstanceOf(ConfigInterface::class, $object);
    }

    public function testEmpty()
    {
        $object = new LibConfig();
        $this->assertNotNull($object->getStoragePath());
        $this->assertNull($object->getPrivacyPolicyHash());
        $this->assertNull($object->getForms());
    }

    public function testCorrectConfig()
    {
        $object = new LibConfig();
        $object->setConfig($this->correct_config);

        $this->assertEquals('./xxx' , $object->getStoragePath());
        $this->assertEquals('sss', $object->getPrivacyPolicyHash());

        $this->assertIsArray($object->getForms());
        $this->assertIsArray($object->getConfig());
    }
}