<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\ClientParam;

/**
 * Class BaseClientParam
 *
 * @package FCAPoland\FormsLib\ClientParam
 *
 */
class BaseClientParam implements ClientParamInterface
{
    /**
     * @var array
     */
    protected $storage = [];

    /**
     * Param getter
     * @param $key
     * @return string|null
     */
    public function getParam($key): ?string
    {
        return $this->storage[$key] ?? null;
    }

    /**
     * @return string|null
     */
    public function getCID(): ?string
    {
        return $this->storage[self::PARAM_CID] ?? null;
    }

    /**
     * @return string|null
     */
    public function getOID(): ?string
    {
        return $this->storage[self::PARAM_OID] ?? null;
    }

    /**
     * @return string|null
     */
    public function getSource(): ?string
    {
        return $this->storage[self::PARAM_SOURCE] ?? null;
    }


    /**
     * @return string|null
     */
    public function getCampaignID(): ?string
    {
        return $this->storage[self::PARAM_CAMPAIGN_ID] ?? null;
    }


    /**
     * @return string|null
     */
    public function getOfferID(): ?string
    {
        return $this->storage[self::PARAM_OFFER_ID] ?? null;
    }


    /**
     * @return string|null
     */
    public function getBannerID(): ?string
    {
        return $this->storage[self::PARAM_BANNER_ID] ?? null;
    }


    /**
     * @return string|null
     */
    public function getAdvertiserID(): ?string
    {
        return $this->storage[self::PARAM_ADVERTISER_ID] ?? null;
    }


    /**
     * @return string|null
     */
    public function getPublisher(): ?string
    {
        return $this->storage[self::PARAM_PUBLISHER] ?? null;
    }

    /**
     * Param setter
     * @param string $kay
     * @param $value
     * @return ClientParamInterface
     */
    public function setParam($kay, $value): ClientParamInterface
    {
        $this->storage[$kay] = $value;
        return $this;
    }

    /**
     * @param $value
     * @return ClientParamInterface
     */
    public function setCID($value): ClientParamInterface
    {
        return $this->setParam(self::PARAM_CID, $value);
    }

    /**
     * @param $value
     * @return ClientParamInterface
     */
    public function setOID($value): ClientParamInterface
    {
        return $this->setParam(self::PARAM_OID, $value);
    }

    /**
     * @param $value
     * @return ClientParamInterface
     */
    public function setSource($value): ClientParamInterface
    {
        return $this->setParam(self::PARAM_SOURCE, $value);
    }


    /**
     * @param $value
     * @return ClientParamInterface
     */
    public function setCampaignID($value): ClientParamInterface
    {
        return $this->setParam(self::PARAM_CAMPAIGN_ID, $value);
    }


    /**
     * @param $value
     * @return ClientParamInterface
     */
    public function setOfferID($value): ClientParamInterface
    {
        return $this->setParam(self::PARAM_OFFER_ID, $value);
    }


    /**
     * @param $value
     * @return ClientParamInterface
     */
    public function setBannerID($value): ClientParamInterface
    {
        return $this->setParam(self::PARAM_BANNER_ID, $value);
    }


    /**
     * @param $value
     * @return ClientParamInterface
     */
    public function setAdvertiserID($value): ClientParamInterface
    {
        return $this->setParam(self::PARAM_ADVERTISER_ID, $value);
    }


    /**
     * @param $value
     * @return ClientParamInterface
     */
    public function setPublisher($value): ClientParamInterface
    {
        return $this->setParam(self::PARAM_PUBLISHER, $value);
    }


    /**
     * @return array
     */
    public function getAllParams(): array
    {
        return [
            'cid' => $this->getCID(),
            'oid' => $this->getOID(),
            'source' => $this->getSource(),
            'campaignid' => $this->getCampaignID(),
            'offerid' => $this->getOfferID(),
            'bannerid' => $this->getBannerID(),
            'advertiserid' => $this->getAdvertiserID(),
            'publisher' => $this->getPublisher(),
        ];
    }

    public function clear()
    {
        $this->storage = [];
    }
}
