<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field\Rule;

use FCAPoland\FormsLib\Field\FieldInterface;
use FCAPoland\FormsLib\Message;

/**
 * Class BaseRule
 * @package FCAPoland\FormsLib\Field\Rule
 */
class BaseRule implements RuleInterface
{
    /**
     * @var string
     */
    protected $regex;


    /**
     * @var FieldInterface
     */
    protected $field;

    /**
     * BaseRule constructor.
     * @param FieldInterface $field
     */
    public function __construct(FieldInterface $field)
    {
        $this->field = $field;
    }

    /**
     * @param $value
     * @return bool
     */
    public function isValidValue($value): bool
    {
        // Zabezpieczenie na nieprzekazanie wartości z pola.
        // np wymagane pole od marki (brand_id) nie jest przekazane czyli w domyśle ma wartość null
        // Dodatkowo sprawdzane jest czy wartość walidowana jest stringiem, dla preg_match to ważne.
        if ($this->field->isRequired() and ($value === null or !is_string($value) and !is_int($value))) {
            return false;
        }
        // preg_match przyjmuje jako 2 parametr stringi
        return (bool) preg_match($this->regex, (string) $value);
    }

    /**
     * @param string $regex
     * @return void
     */
    public function setRegex(string $regex)
    {
        $this->regex = $regex;
    }

    /**
     * @return string
     */
    public function getRegex(): string
    {
        return $this->regex;
    }

    /**
     * @return string
     */
    public function getRuleName(): string
    {
        return get_class($this);
    }

    /**
     * @return string
     */
    public function getFieldClassName(): string
    {
        return $this->field->getFieldClassName();
    }

    /**
     * @return FieldInterface|null
     */
    public function getField(): ?FieldInterface
    {
        return $this->field;
    }

    /**
     * @return string
     */
    public function getMessage(): string
    {
        return Message::getInstance()->getMessageFor($this);
    }
}
