<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field\Rule;

use FCAPoland\FormsLib\Field\FieldInterface;

/**
 * Class MinLength
 * @package FCAPoland\FormsLib\Field\Rule
 */
class MinLength extends BaseRule
{
    /**
     * MinLength constructor.
     * @param FieldInterface $field
     * @param $min_length
     */
    public function __construct(FieldInterface $field, $min_length)
    {
        parent::__construct($field);
        // Auto gen regex for $min_length
        $this->regex = "/^.{{$min_length},}$/";
    }
}
