<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field\Rule;

use FCAPoland\FormsLib\Field\FieldInterface;

/**
 * Interface RuleInterface
 * @package FCAPoland\FormsLib\Field\Rule
 */
interface RuleInterface
{
    /**
     * @param $value
     * @return bool
     */
    public function isValidValue($value): bool;

    /**
     * @param string $regex
     * @return void
     */
    public function setRegex(string $regex);

    /**
     * @return mixed
     */
    public function getRegex(): string;

    /**
     * @return string
     */
    public function getRuleName(): string;

    /**
     * @return string|null
     */
    public function getFieldClassName(): ?string;

    /**
     * @return FieldInterface|null
     */
    public function getField(): ?FieldInterface;

    /**
     * @return string
     */
    public function getMessage(): string;
}
