# FCA FORMS LIB

### Biblioteka do obsługi formularzy dla FCA POLAND

---
#### Funkcje biblioteki:
  - wygenerowanie jsona z informacjami, na których frontend generuje formularz
  - przekazanie pól formularza
  - przekazanie zasad walidacji w formie wyrażeń ragularnych
  - przekazanie danych związanych z polityką prywatności, zgodami itp
  - zapis parametrów wejściowych klienta tj. cid, oid, source
  - przyjmowanie wypełnionych formularzy i ich walidacja
  - wyszukanie przy pomocy lead-api-helpera MasterKey'a bazując na ustawieniach
    formularza oraz parametrów wejściowych klienta
  - zwrócenie do formularza przy niepoprawnej walidacji komunikatów do
    wyświetlenia przy polach z błędami

#### Użycie biblioteki:

1. Dodaj bibliotekę do projektu:
```bash
$ composer require fca-poland/forms-lib
``` 

2. Użyj jej:
```php
<?php
require_once "vendor/autoload.php";

// Wykrycie i zapisanie do sesji wejściowe parametry użytkownika
$cp = new \FCAPoland\FormsLib\ClientParam\SessionClientParam();

if (isset($_GET['cid'])) {
    $cp->setCID($_GET['cid']);
}
if (isset($_GET['oid'])) {
    $cp->setOID($_GET['oid']);
}
if (isset($_GET['source'])) {
    $cp->setSource($_GET['source']);
}
if (isset($_GET['campaignid'])) {
    $cp->setCampaignID($_GET['campaignid']);
}
if (isset($_GET['offerid'])) {
    $cp->setOfferID($_GET['offerid']);
}
if (isset($_GET['bannerid'])) {
    $cp->setBannerID($_GET['bannerid']);
}
if (isset($_GET['advertiserid'])) {
    $cp->setAdvertiserID($_GET['advertiserid']);
}
if (isset($_GET['publisher'])) {
    $cp->setPublisher($_GET['publisher']);
}

// Inicjacja konfiguracji do autoryzacji dla lead-api-helpera na potrzeby zapisu leada w FCA API
$auth_config = new \FCAPoland\FormsLib\Config\FCAAPIAuth();

$auth_config->setConfig([
    'api_url' => 'https://testapi.fcapoland.pl/leads',
    'api_user' => 'xxxxx',
    'api_pass' => 'xxxxx'
]);

// Inicjacja konfiguracji dla forms-lib

 $config = [
            'lead_api_cache' => './cache_lead_api',// Awaryjny cache do zestawu zgód, dealerów itp
            'policy_hash' => 'XXX',
            'forms' => [
                'offerFormTestDrive' => [
                    'id' => 'offerFormTestDrive',
                    'with_dealers' => true,
                    'dealers_list' => ['0075450'],
                    'cta' =>  [
                        \FCAPoland\LeadsAPIHelper\Lead::TYPE_TESTDRIVE => '_TestDrive_',
                         \FCAPoland\LeadsAPIHelper\Lead::TYPE_GETAQUOTE => '_RP_'
                         ],
                    'enabled' => true,
                    'disclaimer_id' => 723,
                    'brand_id'  =>  \FCAPoland\LeadsAPIHelper\Lead::BRAND_ALFA_ROMEO,
                    'cid'    =>  '7777',
                    'oid'    =>  '7777',
                    'source' =>  'dem',
                    'fields' => [
                        \FCAPoland\FormsLib\Field\CTAField::class => [
                            \FCAPoland\FormsLib\Field\BaseField::TYPE_SELECT,
                             [
                                 \FCAPoland\LeadsAPIHelper\Lead::TYPE_TESTDRIVE => '_TestDrive_',
                                 \FCAPoland\LeadsAPIHelper\Lead::TYPE_GETAQUOTE => '_RP_'
                             ]
                        ],
                        \FCAPoland\FormsLib\Field\FirstNameField::class => [],
                        \FCAPoland\FormsLib\Field\LastNameField::class => [],
                        \FCAPoland\FormsLib\Field\EmailField::class => [],
                        \FCAPoland\FormsLib\Field\DealerSincomField::class => [],
                        \FCAPoland\FormsLib\Field\ModelIDField::class => [
                            \FCAPoland\FormsLib\Field\BaseField::TYPE_SELECT, 
                            [
                                '145' => '145 Model',
                            ]
                        ],
                    ],
                ],
            ]
        ];
 
$libconfig = new \FCAPoland\FormsLib\Config\LibConfig();
$libconfig->setConfig($config);

$formManager = new \FCAPoland\FormsLib\FormManager();
$formManager->setLogger(new \Psr\Log\NullLogger());

$formManager->setLibConfig($libconfig);

// Pobranie formularza i zamiana go na obiekt
$form = $formManager->getFormByID('offerFormTestDrive');

// Pobranie formularza jako tablica dla frontendu
$form_array_for_frontend = $form->getFormArray();

// Ustawienie wartości, które zostały wprowadzone w formularzu oraz te pobrane z zapytania
$form->setFormData([
    'cta' => 'RP',
    'firstname' => 'test',
    'lastname' => 'test',
    'email' => 'test@test.com',
    'dealer_sincom' => '0075450.001',
    'model_id' => '145',
    
    // Zgody 
    'agreement_marketing' => '1',
    'agreement_profiling' => '1',
    'agreement_3rdpartymarketing' => '1',
    
    'origin' => 'TEST origin'
]);

// Formularz zostaje sprawdzony. Gdy jest poprawny zapisujemy go 
if ($form->isFormDataValid()) {
    try {
        // Zwracana jest informacja o zapisanym leadzie
        $result = $form->submitForm($auth_config);
    } catch (\Exception $e) {
        // Błąd gdy z jakiegoś powodu lead nie zostanie poprawnie zapisany
    }   
} else {
    // Lista pól formularza, które są wymagane, a nie zostały dostarczone 
    $form_absent_fields = $form->getFormAbsentFields();
    
    // Komunikaty błędów walidacji dla pół form
    $form_error_messages = $form->getFormErrors(); 
}

```
