<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\ClientParam;

/**
 * Interface ClientParamInterface
 * @package FCAPoland\FormsLib\ClientParam
 */
interface ClientParamInterface
{
    const PARAM_CID = 'cp_cid';
    const PARAM_OID = 'cp_oid';
    const PARAM_SOURCE = 'cp_source';

    const PARAM_CAMPAIGN_ID = 'cp_campaignid';
    const PARAM_OFFER_ID = 'cp_offerid';
    const PARAM_BANNER_ID = 'cp_bannerid';
    const PARAM_ADVERTISER_ID = 'cp_advertiserid';
    const PARAM_PUBLISHER = 'cp_publisher';

    /**
     * Param getter
     * @param $key
     * @return string|null
     */
    public function getParam($key): ?string;

    /**
     * @return string|null
     */
    public function getCID(): ?string;

    /**
     * @return string|null
     */
    public function getOID(): ?string;

    /**
     * @return string|null
     */
    public function getSource(): ?string;

    /**
     * @return string|null
     */
    public function getCampaignID(): ?string;

    /**
     * @return string|null
     */
    public function getOfferID(): ?string;

    /**
     * @return string|null
     */
    public function getBannerID(): ?string;

    /**
     * @return string|null
     */
    public function getAdvertiserID(): ?string;

    /**
     * @return string|null
     */
    public function getPublisher(): ?string;

    /**
     * Param setter
     * @param $kay
     * @param $value
     * @return $this
     */
    public function setParam($kay, $value): ClientParamInterface;

    /**
     * @param $value
     * @return $this
     */
    public function setCID($value): ClientParamInterface;

    /**
     * @param $value
     * @return $this
     */
    public function setOID($value): ClientParamInterface;

    /**
     * @param $value
     * @return $this
     */
    public function setSource($value): ClientParamInterface;

    /**
     * @param $value
     * @return $this
     */
    public function setCampaignID($value): ClientParamInterface;

    /**
     * @param $value
     * @return $this
     */
    public function setOfferID($value): ClientParamInterface;

    /**
     * @param $value
     * @return $this
     */
    public function setBannerID($value): ClientParamInterface;

    /**
     * @param $value
     * @return $this
     */
    public function setAdvertiserID($value): ClientParamInterface;

    /**
     * @param $value
     * @return $this
     */
    public function setPublisher($value): ClientParamInterface;

    /**
     * @return array
     */
    public function getAllParams(): array;
}
