<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Config;

use FCAPoland\FormsLib\Exception\InvalidArgumentException;
use TypeError;

/**
 * Class FcaApiAuth
 * @package FCAPoland\FormsLib\Config
 */
class FCAAPIAuth extends BaseConfig
{

    /**
     * @param array $config
     * @throws InvalidArgumentException
     */
    public function setConfig(array $config)
    {
        if (!isset($config['api_url']) or !isset($config['api_user']) or !isset($config['api_pass'])) {
            throw new InvalidArgumentException('FCA LEAD API - AUTH CONFIG INCORRECT');
        }

        try {
            $this->setApiUrl($config['api_url']);
            $this->setApiUser($config['api_user']);
            $this->setApiPass($config['api_pass']);
        } catch (TypeError $e) {
            throw new InvalidArgumentException('FCA LEAD API - AUTH CONFIG INCORRECT (not string values)');
        }
    }

    /**
     * @return String|null
     */
    public function getApiUrl(): ?String
    {
        return $this->config['api_url'] ?? null;
    }

    /**
     * @param String $api_url
     */
    private function setApiUrl(String $api_url)
    {
        $this->config['api_url'] = $api_url;
    }

    /**
     * @return String|null
     */
    public function getApiUser(): ?String
    {
        return $this->config['api_user'] ?? null;
    }

    /**
     * @param String $api_user
     */
    private function setApiUser(String $api_user)
    {
        $this->config['api_user'] = $api_user;
    }

    /**
     * @return String|null
     */
    public function getApiPass(): ?String
    {
        return $this->config['api_pass'] ?? null;
    }

    /**
     * @param String $api_pass
     */
    private function setApiPass(String $api_pass)
    {
        $this->config['api_pass'] = $api_pass;
    }
}
