<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field;

use FCAPoland\FormsLib\Field\Rule\CheckRecaptcha;
use FCAPoland\FormsLib\Field\Rule\NotEmpty;

/**
 * Class RecaptchaField
 * @package FCAPoland\FormsLib\Field
 */
class RecaptchaField extends BaseField
{
    /**
     * @var string
     */
    protected $type = BaseField::TYPE_RECAPTCHA;

    /**
     * @var string
     */
    protected $name = 'g-recaptcha-response';

    /** @var bool */
    protected $required = true;

    /**
     * @var string
     */
    private $site_key;

    /**
     * @var string
     */
    private $secret_key;

    /**
     * FirstNameField constructor.
     * @param $site_key string
     * @param $secret_key string
     */
    public function __construct(string $site_key, string $secret_key)
    {
        $this->secret_key = $secret_key;
        $this->site_key = $site_key;
        $this->setDefaultRules();
    }

    /**
     * Set default rules for this field
     */
    protected function setDefaultRules()
    {
        if (!is_array($this->getOptionValues()) and is_string($this->getOptionValues())) {
            $this->setOptionValues([$this->getOptionValues()]);
        }

        $this->setRules(
            [
                NotEmpty::class => [],
                CheckRecaptcha::class => [$this->site_key, $this->secret_key]
            ]
        );
    }

    /**
     * @return string
     */
    public function getSiteKey(): string
    {
        return $this->site_key;
    }
}
