<?php
declare(strict_types=1);

namespace FCAPoland\FormsLib\Field\Rule;

use FCAPoland\FormsLib\Field\FieldInterface;
use ReCaptcha\ReCaptcha;

/**
 * Class CheckRecaptcha
 * @package FCAPoland\FormsLib\Field\Rule
 */
class CheckRecaptcha extends BaseRule
{

    /**
     * @var string
     */
    private $site_key;

    /**
     * @var string
     */
    private $secret_key;

    /**
     * CheckRecaptcha constructor.
     * @param FieldInterface $field
     * @param $site_key string
     * @param $secret_key string
     */
    public function __construct(FieldInterface $field, string $site_key, string $secret_key)
    {
        parent::__construct($field);
        $this->secret_key = $secret_key;
        $this->site_key = $site_key;
    }


    /**
     * @param $value
     * @return bool
     */
    public function isValidValue($value): bool
    {
        // Zabezpieczenie na nieprzekazanie wartości z pola.
        // np wymagane pole od marki (brand_id) nie jest przekazane czyli w domyśle ma wartość null
        if ($value === null) {
            return false;
        }
        $recaptcha = new ReCaptcha($this->secret_key);
        $recaptcha_response = $recaptcha->verify($value);
        return $recaptcha_response->isSuccess();
    }

    /**
     * @return string
     */
    public function getSiteKey(): string
    {
        return $this->site_key;
    }

    /**
     * @return string
     */
    public function getSecretKey(): string
    {
        return $this->secret_key;
    }
}
